
import pygame, random
pygame.init()

win=pygame.display.set_mode((1000,500))
pygame.display.set_caption('2025 Trump vs Biden battle for blood')

bg=pygame.image.load('bg.jpg')
player=pygame.image.load('idle.png')

it=pygame.image.load('item.png')
it=pygame.transform.scale(it,(60,40))

target=pygame.image.load('biden.png')
target=pygame.transform.scale(target,(40,90))

goLeft=[pygame.image.load('left_1.png'),
        pygame.image.load('left_2.png'),
        pygame.image.load('left_3.png'),
        pygame.image.load('left_4.png'),
        pygame.image.load('left_5.png'),
        pygame.image.load('left_6.png')]

goRight=[pygame.image.load('right_1.png'),
         pygame.image.load('right_2.png'),
         pygame.image.load('right_3.png'),
         pygame.image.load('right_4.png'),
         pygame.image.load('right_5.png'),
         pygame.image.load('right_6.png')]

clock=pygame.time.Clock()

x=50
y=425
width=40
height=60
speed=5

isJump=False
jumpCount=10

animCount=0
left=False
right=False

lastMove=1
projectiles=7
items=[]

class Item:
    def __init__(self,x,y,direct):
        self.x=x
        self.y=y
        self.velocity=8*direct
    def draw(self):
        pygame.draw.circle(win,(255,0,0),
                           (self.x,self.y),5)

class Biden:
    def __init__(self,x,y,hp):
        self.x=x
        self.y=y
        self.hp=hp
    def draw(self):
        pygame.draw.rect(win,(255,0,0),
                         (self.x,self.y,40,90))

biden=Biden(600,400,random.randint(5,20))

def drawWindow():
    global animCount
    win.blit(bg,(0,0))
    win.blit(bg, (500, 0))

    if animCount>29:
        animCount=0

    if left:
        win.blit(goLeft[animCount//5],(x,y))
        animCount += 1
    elif right:
        win.blit(goRight[animCount//5],(x,y))
        animCount += 1
    else:
        win.blit(player,(x,y))

    for item in items:
        #item.draw()
        win.blit(it,(item.x,item.y))

    if biden.hp>0:
        #biden.draw()
        win.blit(target,(biden.x,biden.y))
        font=pygame.font.SysFont('Arial',30)
        hpText=font.render(str(biden.hp),True,
                           (0,0,0))
        win.blit(hpText,(biden.x+5,biden.y))


    font=pygame.font.SysFont('Arial',20)
    nick=font.render('by Ярослав Потапенко',True,(255,255,255))
    win.blit(nick,(10,10))
    pygame.display.update()

run=True
while run:
    clock.tick(30)

    for event in pygame.event.get():
        if event.type==pygame.QUIT:
            run=False
        elif event.type==pygame.KEYUP:
            if keys[pygame.K_f]:
                if len(items)<projectiles:
                    items.append(Item(x+width//2,y,lastMove))
            if keys[pygame.K_b]:
                if biden.hp<1:
                    biden.hp=random.randint(7,20)
                    biden.x = random.randint(100, 900)

    keys=pygame.key.get_pressed()
    if keys[pygame.K_LEFT] and x>speed:
        if y+height>400 and biden.hp>0:
            if x+width<biden.x or x>biden.x+40:
                x-=speed
                left=True
                right=False
                lastMove=-1
        else:
            x-=speed
            left=True
            right=False
            lastMove=-1
    elif keys[pygame.K_RIGHT] and x<1000-speed-width:
        if y+height>400 and biden.hp>0:
            if x + width < biden.x or x > biden.x + 40:
                x+=speed
                left=False
                right=True
                lastMove=1
        else:
            x += speed
            left = False
            right = True
            lastMove=1

    else:
        left=False
        right=False

    if not isJump:
        if keys[pygame.K_SPACE]:
            isJump=True
    else:
        if jumpCount>=-10:
            if jumpCount<0:
                y += (jumpCount**2)//2
            else:
                y -= (jumpCount**2)//2
            jumpCount -= 1
        else:
            isJump=False
            jumpCount=10

    for item in items:
        if item.x>0 and item.x<1000:
            if item.y+40>biden.y and biden.hp>0:
                if (item.x not in range(biden.x,biden.x+40) and
                item.x+60 not in range(biden.x,biden.x+40)):
                    item.x += item.velocity
                else:
                    biden.hp -= 1
                    items.pop(items.index(item))
            else:
                item.x += item.velocity
        else:
            items.pop(items.index(item))

    drawWindow()
    # win.fill((0,0,0))
    # pygame.draw.rect(win,(0,0,255),(x,y,width,height))
    #
    # pygame.display.update()

pygame.quit()