import random
from copy import deepcopy

import pygame
pygame.init()
clock=pygame.time.Clock()
w=10
h=20
tile=45 #pixels
fps=60

win=pygame.display.set_mode((750,895))
pygame.display.set_caption('Tetris 2.0 the BEST')

grid=[pygame.Rect(x*tile,y*tile,tile,tile)
      for x in range(0,w) for y in range(0,h)]

figures_pos=[[(-1,0),(-2,0),(0,0),(1,0)],
             [(0,-1),(-1,-1),(-1,0),(0,0)],
             [(-1,0),(-1,1),(0,0),(0,-1)],
             [(0,0),(-1,0),(0,1),(-1,-1)],
             [(0,0),(0,-1),(0,1),(-1,-1)],
             [(0,0),(0,-1),(0,1),(1,-1)],
             [(0,0),(0,-1),(0,1),(-1,0)]]

figures=[[pygame.Rect(x+w//2,y+1,1,1) for x,y in figur_pos]
         for figur_pos in figures_pos]
figure_rect=pygame.Rect(0,0,tile-2,tile-2)
figure=deepcopy(random.choice(figures))

def checkBorders():
    if figure[i].x<0 or figure[i].x>w-1:
        return False
    elif figure[i].y>h-1 or field[figure[i].y][figure[i].x]:
        return False
    return True

anim_count = 0
anim_speed = 60
anim_limit = 2000

bg=pygame.image.load('bg.jpg')
bg2=pygame.image.load('bg2.jpg')

font1=pygame.font.SysFont('Comic Sans MS',65)
font2=pygame.font.SysFont('Comic Sans MS',45)
font3=pygame.font.SysFont('Comic Sana MS', 20)

author=font3.render('by Kirill Panteleev', True,(140,140,140))
tetris=font1.render('TETRIS',True,(255,140,0))
score=font2.render('score:',True,(0,255,0))
record=font2.render('record:',True,(128,0,128))

score2=0
lines=0
scores={0:0,1:100,2:300,3:700,4:1500}

def getRecord():
     try:
         with open('record') as f:
             return  f.readline()
     except FileNotFoundError:
         with open('record','w') as f:
             f.write('0')
             return '0'
def saveRecord(record2,score2):
    r=max(int(record2),score2)
    with open('record','w') as f:
        f.write(str(r))


def getColor():
    return (random.randint(0,255),
            random.randint(0,255),
            random.randint(0,255))

color=getColor()

nextFigure=deepcopy(random.choice(figures))
nextColor=getColor()

field = [[0 for i in range(0,w)] for j in range(0,h)]

while True:
    record2=getRecord()

    win.fill((0,0,0))
    dx = 0
    rotate = False

    win.blit(bg,(0,0))
    win.blit(bg2, (450, 0))


    for i in range(0,lines):
        pygame.time.wait(200)

    for event in pygame.event.get():
        if event.type==pygame.QUIT:
            exit()
        elif event.type==pygame.KEYDOWN:
            if event.key==pygame.K_LEFT:
                dx = -1
            elif event.key==pygame.K_RIGHT:
                dx = 1
            elif event.key==pygame.K_DOWN:
                anim_limit = 100
            elif event.key==pygame.K_UP:
                rotate=True

    anim_count += anim_speed
    if anim_count>anim_limit:
        anim_count=0
        figure_copy=deepcopy(figure)
        for i in range(0,4):
            figure[i].y += 1
            if not checkBorders():
                for j in range(0,4):
                    field[figure_copy[j].y][figure_copy[j].x]=color
                color=nextColor
                figure=deepcopy(nextFigure)
                nextColor=getColor()
                nextFigure=deepcopy(random.choice(figures))
                anim_limit=2000
                break

    figure_copy=deepcopy(figure)
    for i in range(0,4):
        figure[i].x += dx
        if not checkBorders():
            figure=deepcopy(figure_copy)
            break

    center=figure[0]
    figure_copy=deepcopy(figure)
    if rotate:
        for i in range(0,4):
            x=figure[i].y-center.y
            y=figure[i].x-center.x
            figure[i].x=center.x-x
            figure[i].y=center.y+y
            if not checkBorders():
                figure=deepcopy(figure_copy)
                break

    line=h-1
    lines=0
    for row in range(h-1,-1,-1):
        count=0
        for i in range(0,w):
            if field[row][i]:
                count+=1
            field[line][i]=field[row][i]
        if count<w:
            line-=1
        else:
            lines+=1
            anim_speed+=1

    score2+=scores[lines]

    [pygame.draw.rect(win,(40,40,40),item,1)
     for item in grid]

    for i in range(0,4):
        figure_rect.x=figure[i].x*tile
        figure_rect.y=figure[i].y*tile
        pygame.draw.rect(win,color,figure_rect)

    for y, row in enumerate(field):
        for x, col in enumerate(row):
            if col:
                figure_rect.x=x*tile
                figure_rect.y=y*tile
                pygame.draw.rect(win,col,figure_rect)

    for i in range(0,4):
        figure_rect.x=nextFigure[i].x*tile+400
        figure_rect.y=nextFigure[i].y*tile+100
        pygame.draw.rect(win,nextColor,figure_rect)

    win.blit(tetris,(475,0))
    win.blit(author,(500,85))
    win.blit(score,(535,730))
    win.blit(record,(525,600))
    win.blit(font2.render(str(score2),True,(0, 255, 0)),(580,795))
    win.blit(font2.render(record2,True,(128,0,128)),(580,665))

    for i in range(0,w):
        if field [0][i]:
            saveRecord(record2,score2)
            field=[[0 for j in range(0,w)] for i in range(0,h)]
            anim_count=0
            anim_speed=60
            anim_limit=2000
            score2=0
            for q in range(0,3):
                 for item in grid:
                     pygame.draw.rect(win,getColor(),item)
                     pygame.display.update()
                     clock.tick(240)


    pygame.display.update()
    clock.tick(fps)
